//------------------------------------------------------------------------------
// File: Escort.cs
// Handles escort mission
// Author: Michael Felice
//------------------------------------------------------------------------------


// SCENARIO CALLBACK FUNCTIONS for Escort Mission

// load scenario function (initializes the escort mission tasks)
function startEscortTasks()
{
   InitializeQuestGui();
         
   tsStartTask("Escort", "EscortInit");
   //Spawn Escort Bandit
   if($escortsex $= "female")
   {
     %escortbandit = tsCreateObj("Femalebandit", "Escortee", $OST_NEUTRAL, "-305 -370", "Escortee");
     %escortbandit.name = $escortname; 
   }
   else
   {
      %escortbandit = tsCreateObj("malebandit", "Escortee", $OST_NEUTRAL, "-305 -370", "Escortee");
      %escortbandit.name = $escortname; 
   }
   
   // disable build button
   tsEnableCommand(BuildCmdData, false);
}

// quit scenario function (turns off the escort mission task)
function resetEscortTasks()
{
   TaskModifier.strResetVertex("MainmapTasks", "EscortLoad");
   TaskModifier.strMarkVertex("MainmapTasks", "EscortLoad", $TSV_AVAIL);
}
function endEscortTasks()
{
    tsEndTask("Escort");
}

// MAIN SET OF TASKS

// send dialog to the escort
function EscortInit::onExit(%vertex)
{
   // the escorted characters starts the conversation
   tsSendTaskClickDlg("ID_TASKNAME_ESCORT", "id_escort_intro",
      $TaskButton::Okay, "Escortee", "id_escort_intro");
   
   // add the optional quest for the gunslinger rescue
   tsAddQuestToTracker(false, "Rescue Gunslinger", "", "You found a Gunslinger who is willing to help out if you can take care of the Bandits that captured him.", "Reward: Gunslinger backup");
}

// after confirmation, update the team of the excorted bandit
function EscortBegin::onExit(%vertex)
{
   %name = getWord(Escortee.name, 0);

   // Quest log
   tsAddQuestToTracker(true, "Escort Mission", "", "Escort " @ Escortee.name @ " out of town and over the river to the next town over. Keep a sharp eye out for ambushes along the way.", "Reward: 5 Experience");
   tsAddTaskToTracker("Escort Mission", "Get " @ %name @ " safely out of the area.",
      "Escort " @ Escortee.name @ " safely across the river and southeast to the road to the next town.");
   tsAddTaskToTracker("Escort Mission", %name @" must survive.", "Make sure nothing happens to "@%name@".");
   tsReadyQuest("Escort Mission");
}

// provide a warning for the escort
function EscortWarning1::onExit(%vertex)
{
   tsSendTaskClickDlg("ID_TASKNAME_ESCORT", "id_escort_warning1", $TaskButton::More, "Es1", "id_escort_warning1");
}

// reply to the warning about the escort
function EscortWarning2::onExit(%vertex)
{
   tsSendTaskPopUpDlg("ID_TASKNAME_ESCORT", "id_escort_warning2",
      $TaskButton::Okay, "HeroCharacter", "id_escort_warning2");
   
   // allow the escortee to be moved
   Escortee.setTeam($OST_PLAYER);
   
   // update the quest
   %name = getWord(Escortee.name, 0);
}

// when the treeline landmark is reached
function EscortTreeline1::onExit(%vertex)
{
   // create the bandits
   %bandit1 = tsCreateObj("Malebandit", "", $OST_NEUTRAL, "-324 -289", "");
   %bandit2 = tsCreateObj("Malebandit", "", $OST_NEUTRAL, "-322 -287", "");
   %bandit3 = tsCreateObj("Femalebandit", "", $OST_NEUTRAL, "-320 -284", "");
   %bandit1.setInternalName("bandit1");
   %bandit2.setInternalName("bandit2");
   %bandit3.setInternalName("bandit3");
   %bandit1.setName("bandit1");
   %bandit2.setName("bandit2");
   %bandit3.setName("bandit3");
   
   // supply the bandit dialog
   tsSendTaskPopUpDlg("ID_TASKNAME_ESCORT", "id_escort_treeline1", $TaskButton::More, "bandit1", "id_escort_treeline1");
   
   tsSendTaskPopUpDlg("ID_TASKNAME_ESCORT", "id_escort_treeline2", $TaskButton::Okay, "HeroCharacter", "id_escort_treeline2");
   
   // set up a temp bandit for character display
   %temp = tsCreateObj("Malebandit", "", $OST_NEUTRAL, "0 0", "");
   %temp.setInternalName("tempBandit");
   %temp.setName("tempBandit");
   %temp.name = %bandit1.name;
   
   // set traps
   TaskModifier.strMarkVertex("Escort", "EscortCampfire1", $TSV_AVAIL);
   TaskModifier.strMarkVertex("Escort", "EscortRiver1", $TSV_AVAIL);
   TaskModifier.strMarkVertex("Escort", "EscortSafe", $TSV_AVAIL);   
}

// and the first attack begins
function EscortTreeline3::onExit(%vertex)
{
   // turn all of the bandits into enemies
   %bandit1 = nameToId("bandit1");
   %bandit2 = nameToId("bandit2");
   %bandit3 = nameToId("bandit3");
   %bandit1.setTeam(2);
   %bandit2.setTeam(2);
   %bandit3.setTeam(2);
   
   %escortee = nameToId(Escortee);
   %hero = nameToId(HeroCharacter);
   
   // launch the bandit attack (randomly between the hero and the target)
   %ai1 = slgQueryInterface(%bandit1, $CID_AI);
   %ai2 = slgQueryInterface(%bandit2, $CID_AI);
   %ai3 = slgQueryInterface(%bandit3, $CID_AI);
   if (getRandom(0, 1) == 0) tsStartBanditAttack("bandit1", %escortee);
   else %ai1.performAction("attack", %hero);
   if (getRandom(0, 1) == 0) %ai2.performAction("attack", %escortee);
   else %ai2.performAction("attack", %hero);
   if (getRandom(0, 1) == 0) %ai3.performAction("attack", %escortee);
   else %ai3.performAction("attack", %hero);
}

// the first wave of bandits have been defeated
function EscortTreeline4::onExit(%vertex)
{
   // warning message for next step
   tsSendTaskPopUpDlg("ID_TASKNAME_ESCORT", "id_escort_treeline3", $TaskButton::Okay, "tempBandit", "id_escort_treeline3");
}

// surprised dialog
function EscortCampfire1::onExit(%vertex)
{
   // delete the temp bandit
   %temp = nameToId("tempBandit");
   %temp.DeleteObject();
   
   // add the pop up dialog
   tsSendTaskPopUpDlg("ID_TASKNAME_ESCORT", "id_escort_campfire1", $TaskButton::More, "HeroCharacter", "id_escort_campfire1");
   tsSendTaskPopUpDlg("ID_TASKNAME_ESCORT", "id_escort_campfire2", $TaskButton::Okay, "Escortee", "id_escort_campfire2");
}

// set up the second set of attackers
function EscortCampfire3::onExit(%vertex)
{
   // create the bandits
   %bandit4 = tsCreateObj("Malebandit", "", $OST_NEUTRAL, "-272 -275", "");
   %bandit5 = tsCreateObj("Femalebandit", "", $OST_NEUTRAL, "-278 -262", "");
   %bandit6 = tsCreateObj("Femalebandit", "", $OST_NEUTRAL, "-288 -252", "");
   %bandit4.setInternalName("bandit4");
   %bandit5.setInternalName("bandit5");
   %bandit6.setInternalName("bandit6");
   %bandit4.setName("bandit4");
   %bandit5.setName("bandit5");
   %bandit6.setName("bandit6");
   
   // supply the bandit dialog
   tsSendTaskPopUpDlg("ID_TASKNAME_ESCORT", "id_escort_campfire3",
      $TaskButton::More, "bandit4", "id_escort_campfire3");
   
   // set up a temp bandit for character display
   %temp = tsCreateObj("Malebandit", "", $OST_NEUTRAL, "0 0", "");
   %temp.setInternalName("tempBandit");
   %temp.setName("tempBandit");
   %temp.name = %bandit4.name;
   
   // and the hero reply
   tsSendTaskPopUpDlg("ID_TASKNAME_ESCORT", "id_escort_campfire4", $TaskButton::Okay, "HeroCharacter", "id_escort_campfire4");
   
   
}

// begin the attack
function EscortCampfire5::onExit(%vertex)
{
   // turn all of the bandits into enemies
   %bandit4 = nameToId("bandit4");
   %bandit5 = nameToId("bandit5");
   %bandit6 = nameToId("bandit6");
   %bandit4.setTeam(2);
   %bandit5.setTeam(2);
   %bandit6.setTeam(2);
   
   %escortee = nameToId(Escortee);
   %hero = nameToId(HeroCharacter);
   
   // launch the bandit attack (randomly between the hero and the target)
   %ai4 = slgQueryInterface(%bandit4, $CID_AI);
   %ai5 = slgQueryInterface(%bandit5, $CID_AI);
   %ai6 = slgQueryInterface(%bandit6, $CID_AI);
   if (getRandom(0, 1) == 0) %ai4.performAction("attack", %escortee);
   else %ai4.performAction("attack", %hero);
   if (getRandom(0, 1) == 0) %ai5.performAction("attack", %escortee);
   else %ai5.performAction("attack", %hero);
   if (getRandom(0, 1) == 0) %ai6.performAction("attack", %escortee);
   else %ai6.performAction("attack", %hero);
}

// the second wave of bandits have been defeated
function EscortCampfire6::onExit(%vertex)
{
   // warning message for next step
   tsSendTaskPopUpDlg("ID_TASKNAME_ESCORT", "id_escort_campfire5",
      $TaskButton::Okay, "tempBandit", "id_escort_campfire5");
   
   // complete the quest
   %name = getWord(Escortee.name, 0);

}

// start more dialog after reaching clearing on other side of river
function EscortRiver1::onExit(%vertex)
{
   // delete the temp bandit
   %temp = nameToId("tempBandit");
   %temp.DeleteObject();
   
   // add the pop up dialog
   tsSendTaskPopUpDlg("ID_TASKNAME_ESCORT", "id_escort_river1",
      $TaskButton::More, "HeroCharacter", "id_escort_river1");
}

// escortee replies to dialog from hero
function EscortRiver2::onExit(%vertex)
{
   // add the pop up dialog
   tsSendTaskPopUpDlg("ID_TASKNAME_ESCORT", "id_escort_river2",
      $TaskButton::Okay, "Escortee", "id_escort_river2");
}

// set up bandits for the third attack and talk some smack
function EscortRiver3::onExit(%vertex)
{
   // create the bandits
   %bandit7 = tsCreateObj("Femalebandit", "", $OST_NEUTRAL, "-156 -196", "");
   %bandit8 = tsCreateObj("Malebandit", "", $OST_NEUTRAL, "-165 -199", "");
   %bandit9 = tsCreateObj("Femalebandit", "", $OST_NEUTRAL, "-163 -191", "");
   %bandit10 = tsCreateObj("Malebandit", "", $OST_NEUTRAL, "-147 -193", "");
   %bandit7.setInternalName("bandit7");
   %bandit8.setInternalName("bandit8");
   %bandit9.setInternalName("bandit9");
   %bandit10.setInternalName("bandit10");
   %bandit7.setName("bandit7");
   %bandit8.setName("bandit8");
   %bandit9.setName("bandit9");
   %bandit10.setName("bandit10");
   
   // supply the bandit dialog
   tsSendTaskPopUpDlg("ID_TASKNAME_ESCORT", "id_escort_river3",
      $TaskButton::More, "bandit7", "id_escort_river3");
   
   tsSendTaskPopUpDlg("ID_TASKNAME_ESCORT", "id_escort_river4",
      $TaskButton::Okay, "HeroCharacter", "id_escort_river4");
      
}

// begin the third wave of attacks
function EscortRiver5::onExit(%vertex)
{
   // turn all of the bandits into enemies
   %bandit7 = nameToId("bandit7");
   %bandit8 = nameToId("bandit8");
   %bandit9 = nameToId("bandit9");
   %bandit10 = nameToId("bandit10");
   %bandit7.setTeam(2);
   %bandit8.setTeam(2);
   %bandit9.setTeam(2);
   %bandit10.setTeam(2);
   
   %escortee = nameToId(Escortee);
   %hero = nameToId(HeroCharacter);
   
   // launch the bandit attack (randomly between the hero and the target)
   %ai7 = slgQueryInterface(%bandit7, $CID_AI);
   %ai8 = slgQueryInterface(%bandit8, $CID_AI);
   %ai9 = slgQueryInterface(%bandit9, $CID_AI);
   %ai10 = slgQueryInterface(%bandit10, $CID_AI);
   if (getRandom(0, 1) == 0) %ai7.performAction("attack", %escortee);
   else %ai7.performAction("attack", %hero);
   if (getRandom(0, 1) == 0) %ai8.performAction("attack", %escortee);
   else %ai8.performAction("attack", %hero);
   if (getRandom(0, 1) == 0) %ai9.performAction("attack", %escortee);
   else %ai9.performAction("attack", %hero);
   if (getRandom(0, 1) == 0) %ai10.performAction("attack", %escortee);
   else %ai10.performAction("attack", %hero);
}

// attacks are complete, bandits have died, escortee comments
function EscortRiver6::onExit(%vertex)
{
   // escortee makes a comment
   tsSendTaskPopUpDlg("ID_TASKNAME_ESCORT", "id_escort_river5",
      $TaskButton::Okay, "Escortee", "id_escort_river5");
}

// escort has reached the save spot (complete mission)
function EscortSafe::onExit(%vertex)
{
   // If all bandits defeated    
   if(escortbanditdefeat.isMarkedComplete())
   {
      %name = getWord(Escortee.name, 0);
         
      tsSendTaskPopUpDlg("ID_TASKNAME_ESCORT", "id_escort_sheriff", $TaskButton::Okay, "escortsheriff", "id_escort_sheriff");
      tsSendTaskClickDlg("ID_TASKNAME_ESCORT", "id_escort_winAccept", $TaskButton::Accept, "Escortee", "id_escort_winAccept");
      tsConvertObjTeam("Escortee", 0);
      //Move next to Sheriff
      tsMoveObjToTarget("Escortee", "-220 -97");
      
      // Quest log
      tsCompleteTaskInTracker("Escort Mission", "Escort " @ %name @ " safely out of the area.");
      tsCompleteTaskInTracker("Escort Mission", %name @" must survive.");
   }
   else
   {
      tsSendTaskPopUpDlg("ID_TASKNAME_ESCORT", "id_escort_sheriffnotsafe", $TaskButton::Okay, "escortsheriff", "id_escort_sheriffnotsafe");
      
      // Quest log
      tsAddTaskToTracker("Escort Mission", "Defeat Bandits.", "Defeat the remaining bandits.");
      TaskModifier.strMarkVertex("Escort", "EscortSafePath2", $TSV_AVAIL);
      
   }
}
function escortbanditdefeat::onEnter(%vertex)
{
   TaskModifier.strMarkVertex("Escort", "escortbanditdefeat", $TSV_CMPLETE); 
}
function EscortSafePath2::onUpdate(%vertex)
{
   if(escortbanditdefeat.isMarkedComplete())
   {
      TaskModifier.strMarkVertex("Escort", "EscortSafePath2", $TSV_CMPLETE);
      
      // Quest log
      tsCompleteTaskInTracker("Escort Mission", "Defeat Bandits."); 
   }
}
function EscortSafePath2Zone::onExit(%vertex)
{
   %name = getWord(Escortee.name, 0);
         
   tsSendTaskPopUpDlg("ID_TASKNAME_ESCORT", "id_escort_sheriff", $TaskButton::Okay, "escortsheriff", "id_escort_sheriff");
   tsSendTaskClickDlg("ID_TASKNAME_ESCORT", "id_escort_winAccept", $TaskButton::Accept, "Escortee", "id_escort_winAccept");
   tsConvertObjTeam("Escortee", 0);
   //Move next to Sheriff
   tsMoveObjToTarget("Escortee", "-220 -97");
   
   // Quest log
   tsCompleteTaskInTracker("Escort Mission", "Escort " @ %name @ " safely out of the area.");
   tsCompleteTaskInTracker("Escort Mission", %name @" must survive.");
}
function EscortWinDelayPath2::onExit(%vertex)
{
   TaskModifier.strMarkVertex("Escort", "EscortWinDelay", $TSV_CMPLETE); 
}

// escort mission is complete, so move back to the main map
function EscortWinDelay::onExit(%vertex)
{
   // we do not want to carry back the escorted character
   Escortee.setTeam($OST_NEUTRAL);
   
   // return from this satellite
   %scenario = new SLScenario()
   {
        stack = false;
        
        toughGunslinger = true;
   };
   LoadScenario(%scenario, endEscortTasks, winEscortComplete);
   
   // complete the escort satellite
   mapsatellite_escort.disabled = false;
}

////////////////////////////////////////////////////////////////////////////////
//! Rewards the player if the task is successfully completed
////////////////////////////////////////////////////////////////////////////////
function winEscortComplete()
{
   // Reward
   tsModifyResource($Resource::Experience, 15, true);
   SendProductionToClient(HeroCharacter, "15 experience");
   
   TaskModifier.strMarkVertex("MainmapTasks", "EscortComplete", $TSV_AVAIL);
   townspy.deleteObject();
}

// GUNSLINGER RESCUE SIDE MISSION

// the gunslinger pleeds for your help
function EscortHostage1::onExit(%vertex)
{
   // gunslinger asks for help
   tsSendTaskPopUpDlg("ID_TASKNAME_ESCORT", "id_escort_hostage",
      $TaskButton::Okay, "Es4", "id_escort_hostage");
}

// the dialog has been accepted, so get ready for a fight
function EscortHostage2::onExit(%vertex)
{
   // update the rescue mission
   tsAddTaskToTracker("Rescue Gunslinger", "Rescue the captive Gunslinger.",
      "Take out the Bandits that are guarding the Gunslinger.  " @ Es4.name @ " has offered his assistance with the escort mission if you bust him out.");
   tsReadyQuest("Rescue Gunslinger");
}

// the bandits guarding the gunslinger are no longer around
function EscortHostage3::onExit(%vertex)
{
   // free the gunslinger
   Es4.setTeam($OST_PLAYER);
   
   tsRemoveObj("fence1");
   tsRemoveObj("fence2");
   
   // complete the side mission
   tsCompleteTaskInTracker("Rescue Gunslinger", "Rescue the captive Gunslinger.");
}

// FAIL MISSION

// mission was lost, so have the option of restart or quit mission
function EscortLose::onExit(%vertex)
{
   //Move to dying unit
   tsMoveCameraToObject("Escortee", true);
}
function EscortLoseDelay::onExit(%vertex)
{
   // give the restart options
   tsRestartScenario("id_escort_losedialog",
      "id_escort_restartbutton", "id_escort_quitbutton");
}
